{
	Unit complet de gestion des sons sur 8/12/16 bits en mono ou stro
	(c) 1991,1992,1993 Fabrice BELLARD version 2.01 & ESAT Software
	TAB=3 SPACES

	Version 2.01:
	- Gestion des cartes:
		cdata.l: mot poids faible de cdata
		cdata.h: mot poids fort de cdata

		- haut parleur PC (lger changement)
			cdata=0: vitesse simple
			cdata=1:	vitesse double
		- SoundBlaster avec DMA
			cdata=0:	adresses par dfaut: port $220 , interruption 7
			sinon: 	cdata.h=int, cdata.l=port
		- SoundBlaster sans DMA
               cdata=0:	port $220 (dfaut)
			sinon port=cdata.l
		- adlib
			aucun paramtre
		- Cartes gnriques sur port parallle (on y trouve aussi pas
			mal de cartes exotiques: il suffit de prciser l'adresse
			cdata=0:	port parallle 1
               si cdata.h=0 alors sur port parallle LPT: cdata.l=1,2,3,4
			sinon cdata.h=port de la carte (adresse physique)
		- Carte Covox:
			aucun paramtre
		- Carte Mini
			cdata=0: port LPT1
			sinon LPT cdata

	- Multi-tche transparent permettant:
		- dcompression en temps rel
		- calcul de son en temps rel (voir RPMOD)
		- animation graphique, ou mme jeux

	- Gestion trs simple de la mono et stro: Utilisation de la mthode
		du double buffer sur les 2 voies pour un maximum de souplesse.

	- Frquence de restitution indpendante de la carte, sans limite
		si la carte et le PC sont assez rapides.

	- Gestion de tous les paramtres de configuration: choix de la frquence
		optimale suivant la vitesse du PC, Nom de la carte, type de sample
		etc...
	- Possibilit de faire du sampling avec les cartes le supportant
		(pour l'instant SoundBlaster avec ou sans DMA)

	- Possibilit de fonctionnement autonome grce au gestionnaire de mmoire
		indpendant du langage. (fonctions DSMalloc et DSFree)
}

{	unit pour jouer les modules Amiga (c) 1991,1992 F. BELLARD
 	version 2.01
	TAB=3 SPACES
	Note: ce module ncessite la librairie DSOUND pour fonctionner
	correctement.

version 2.00:
	- Gestion de 255 instruments max. et 8 voies max.
	- Gestion des commandes Protracker V1.1B et NT2.0
	- multi-tche transparent pour le programmeur
	- ncessite le retournement des mots du patterns du .MOD
	- Possibilit de stro ou mono suivant la carte
	- Les 8 voies sont dsactivables sparemment
	- Possibilit de fonctionnement  n'importe quelle frquence suivant
		la vitesse de la machine et la carte
	- Gestion complte de instrrep et instrofs
	- Gestion des valeurs des barres de volume
	- Note: Pour l'instant, l'effet "Funk" modifie l'chantillon utilis.
}

{	Ce unit sert  charger facilement des modules dans la structure
	TRPMModule de RpMod. Il n'est pas indispensable au fonctionnement du
	player.
	TAB=3 SPACES
	- LoadMod Gre actuellement les modules avec toutes les commandes du
	protracker, y compris la commande FineTune pour chaque instrument.
	Il peut charger les modules .MOD, .MOD compacts, .HMS, .HMX, et .STX
	(8 voies).
	- Le champ SampleName de TRPMModule n'est pas rempli par cette fonction.
}

{$S-,R-,N-,G-,F-}
unit SoundDRV;

interface

uses dos;

{ ******************************** DSOUND ********************************* }

const
{ types de cartes }
	DSCARD_HPPC		= 0;
	DSCARD_SB		= 1;
	DSCARD_SBDMA	= 2;
	DSCARD_ADLIB	= 3;
	DSCARD_PARA		= 4;
	DSCARD_COVOX	= 5;
	DSCARD_MINI		= 6;

{ messages d'erreurs }
	DSER_NOERROR		= 0;		{ Pas d'erreur }
	DSER_BADPARAM		= 1;		{ mauvais paramtre }
	DSER_NOMEMORY		= 2;		{ pas assez de mmoire }
	DSER_SOUNDINUSE	= 3;		{ tentative de lancer 2 fois de suite StartDSound }
	DSER_BADHARD		= 4;		{ hardware incorrect }
	DSER_NODRIVER		= 5;		{ Pas de driver charg }
	DSER_DISK			= 6;		{ Erreur disque }

{ messages d'tat renvoy par GetDSoundStatus }
	DSST_NOSOUND			= 0;		{ pas de son jou actuellement }
	DSST_SOUND				= 1;		{ son jou actuellement }
	DSST_SOUNDSTOPPED 	= 2;		{ un son est jou, mais il a t stopp par l'utilisateur }
	DSST_SOUNDERROR		= 3;		{ une erreur d'est produite pendant que le
												son tait jou (ie:carte trop lente) }

{ carte connecte ou pas sur le PC }
	CARDONPC_NO			=0;
	CARDONPC_YES		=1;
	CARDONPC_UNKNOWN	=2;

{ types de samples }
	DSTYPE_UNSIGNED8		= $0001;
	DSTYPE_STUNSIGNED8	= $0002;
	DSTYPE_UNSIGNED16		= $0004;
	DSTYPE_STUNSIGNED16	= $0008;

{ structure pour lancer le son }
type
	TDSMalloc=function(len:word):pointer;
	TDSFree=procedure(p:pointer;len:word);

	TSoundProc=function(buf:pointer;size:word):integer;
	TDSoundInfo=record
		CardType:word;			{ type de carte: voir constantes DSCARD_x }
		CardData:longint;		{ donnes complmentaires: 0=dfaut }
		SampleFreq:word;		{ TCardInfo.CardFreqMin<=freq<=TCardInfo.CardFreqMax }
		SampleType:word;		{ type de sample: voir les constantes DSTYPE_x }

{ fonction que DSOUND appelle  chaque fois qu'il a besoin de sortir un
morceau de sample sur la carte sonore. "buf" est un pointeur sur le buffer
que le programme appelant doit absolument remplir de "size" octets. Notons
que size est toujours un multiple de 4 au minimum. La fonction SoundProc doit
renvoyer 0 en temps normal, et une valeur non nulle pour terminer la
reproduction. Dans ce cas, StopDSound doit tre quand mme appel aprs.
}
		SoundProc:TSoundProc;

	end;

{ structure d'info pour la carte }
	TCardInfo=record
		CardType:word;			{ type de carte }
		CardName:string[40];	{ nom de la carte }
		CardOnPC:word;			{ si la carte est sur le PC }

		OutFreqMax:word;		{ frquence maximale en sortie}
		OutFreqMin:word;		{ frquence minimale en sortie }
		OutFreqBest:word;		{ frquence idale suivant le PC }
		OutSampleType:word;	{ samples supports en sortie }
		OutLowVolume:word;	{ <>0 si la carte a un volume faible -> utilisation de la saturation }

		InOption:word;			{ <>0 si la carte peut faire de la digit }
		InFreqMin:word;		{ idem que outxxx }
		InFreqMax:word;
		InFreqBest:word;
		InSampleType:word;
	end;

{ info pour savoir le nombre de cartes, et la meilleure carte }
	TCardGlobalInfo=record
		NbCard:word;
		BestCard:word;
	end;

{ initialisation:  appeler au dbut du programme }
function InitDSound:integer;

{ si l'on veut installer son propre gestionnaire de mmoire }
procedure SetDSMemProc(mymalloc:TDSMalloc;myfree:TDSFree);

{ si l'on ne veut pas de gestionnaire de mmoire, mais une zone assez grande
  que dsound gre tout seul }
procedure SetDSMemPtr(pt:pointer;size:longint);
{ dans ce cas, on veut connaire la place disponible }
function GetDSMemSize:longint;

{ jouer et arrter un sample }
function StartDSound(var SD:TDSoundInfo):integer;
function StopDSound:integer;

{ idem pour enregistrer }
function StartDSoundIN(var SD:TDSoundInfo):integer;
function StopDSoundIN:integer;

{ status en sortie ou en entre: voir constantes DSST_x }
function GetDSoundStatus:integer;

{ les fonctions suivantes ne sont pas indispensables: elles servent 
	connaitre les caractristiques d'une carte sonore }

{ info sur la carte spcifie dans CINF.CardType }
function GetCardInfo(var CINF:TCardInfo):integer;

{ Nombre de cartes et meilleur carte trouve }
procedure GetCardGlobalInfo(var CGINF:TCardGlobalInfo);

{	Pour avoir la frquence exacte de restitution: certaines cartes ne peuvent
	pas jouer un son  toutes les frquences possibles. Cette fonction donne
	la frquence de la carte la plus proche d'une frquence donne
}
function GetAccurateFreq(ctype:word;cdata:longint;freq:word):word;

{ ******************************** RPMOD ********************************* }

{ structures pour les modules }
type
	TRPMSampleRec=record
		SplPtr:pointer;	{ pointeur sur le sample }
		SplSize:word;		{ taille du sample, en octets }
		SplRepAdr:word;	{ adresse de rptition du sample, en octets }
		SplRepLen:word;	{ longueur de rptition en octets, =2 : pas de rep }
		SplFineTune:byte;	{ FineTune:Ajout Protracker, 0 par dfaut }
		SplVol:byte;		{ volume de 0  64 }
	end;
	TRPMSample=array[0..255] of TRPMSampleRec;
	PRPMSample=^TRPMSample;

	TRPMSampleName=array[0..255] of string[22];
	PRPMSampleName=^TRPMSampleName;

{ attention: les mots dans les commandes du pattern sont au format PC }
	TRPMCmd=record note,cmd:word end;
	TRPMPatternRec4=array[0..63,0..3] of TRPMCmd;
	TRPMPatternRec8=array[0..63,0..7] of TRPMCmd;
	TRPMPattern=array[0..127] of pointer;

	TRPMModule=record
		{ samples }
		NbSample:word;					{ nombre de samples }
		Sample:PRPMSample;			{ description des samples }
		SampleName:PRPMSampleName;	{ nom des sample: OPTIONNEL, =nil si pas utilis }
		{ patterns }
		NbVoice:word;					{ nombre de voies: 4 ou 8 }
		NbPattern:word;				{ nombre de patterns diffrents }
		Pattern:TRPMPattern;			{ pointeurs patterns }
		{ index patterns }
		NbPatternidx:word;			{ nombre de patterns  jouer }
		Patternidx:array[0..127] of byte;	{ index des patterns }
		{ nom du module }
		modtitle:string[20];			{ nom du module: OPTIONNEL }
	end;


{ pour avoir des infos sur le module jou }
type
	TRPMStatus=record
		voice:array[0..7] of record
			ok:integer;			{ <>0 si la voie est active }
			vol:integer;		{ volume }
			instr:integer;		{ numro de sample en cours }
			period:integer;	{ frquence }
			bar:integer;		{ valeur pour la barre de 1  64 }
		end;
		pat:integer;			{ numro de pattern }
		patidx:integer;		{ position dans PatternIdx }
		patpos:integer;		{ position dans le pattern }
		speed:integer;			{ vitesse actuelle }
		volout:integer;		{ volume de sortie }
		balance:integer;		{ balance de sortie:
			-64: tout sur gauche, 0 quilibr, 64 tout sur droit }
	end;

{ lancer un module }
function StartRPMod(var DSinfo:TDSoundInfo;var Module:TRPMModule):integer;

{ arreter de jouer le module }
function StopRPMod:integer;

{ mettre une voie sur on/off }
procedure SetRPMVoice(voice:integer;vok:integer);

{ changement de volume et de balance }
procedure SetRPMVolOut(vout,bal:integer);

{ fix le numro de pattern  jouer }
procedure SetRPMPattern(pat:integer);

{ pour avoir l'tat de toutes les voies }
procedure GetRPMStatus(var RPMS:TRPMStatus);

{ ******************************** RPMODIO ******************************** }

{ Chargement d'un module }
function LoadMod(var M:TRPMModule;var name:string):integer;

{ Libration de la zone mmoire occupe par le module }
procedure FreeMod(var M:TRPMModule);



implementation

const
	INTMIN=$80;
	INTMAX=$BF;
	IDSTR=$444E5344;
	IDOFS=$0000;

var
	nint:integer;

{ si le driver est dj charg, renvoie son numro d'interruption }
function GetInt:integer;
var int:word;
	p:pointer;

begin
	for int:=INTMIN to INTMAX do begin
		getintvec(int,p);
		if p<>nil then begin
			if meml[seg(p^):IDOFS]=IDSTR then begin
				GetInt:=int;
				exit;
			end;
		end;
	end;
	GetInt:=-1;
end;

function InitDSound:integer;
begin
	nint:=GetInt;
	if nint<0 then InitDSound:=DSER_NODRIVER else InitDSound:=0;
end;

procedure SetDSMemProc(mymalloc:TDSMalloc;myfree:TDSFree);
var reg:registers;
begin
	reg.AX:=9;
	reg.BX:=ofs(mymalloc);
	reg.ES:=seg(mymalloc);
	reg.CX:=ofs(myfree);
	reg.DX:=seg(myfree);
{ La valeur DS envoye ici est celle qui est utilise lors de l'appel des
  fonctions mymalloc et myfree }
	reg.DS:=DSeg;
	intr(nint,reg);
end;

procedure SetDSMemPtr(pt:pointer;size:longint);
var reg:registers;
begin
	reg.AX:=10;
	reg.BX:=ofs(pt^);
	reg.ES:=seg(pt^);
	reg.CX:=size;
	reg.DX:=size shr 16;
	intr(nint,reg);
end;

function GetDSMemSize:longint;
var reg:registers;
begin
	reg.AX:=11;
	intr(nint,reg);
	GetDSMemSize:=(longint(reg.DX) shl 16)+reg.AX;
end;

function StartDSound(var SD:TDSoundInfo):integer;
var reg:registers;
begin
	reg.AX:=1;
	reg.BX:=ofs(SD);
	reg.ES:=seg(SD);
	intr(nint,reg);
	StartDSound:=reg.AX;
end;

function StopDSound:integer;
var reg:registers;
begin
	reg.AX:=2;
	intr(nint,reg);
	StopDSound:=reg.AX;
end;

function StartDSoundIN(var SD:TDSoundInfo):integer;
var reg:registers;
begin
	reg.AX:=3;
	reg.BX:=ofs(SD);
	reg.ES:=seg(SD);
	intr(nint,reg);
	StartDSoundIN:=reg.AX;
end;

function StopDSoundIN:integer;
var reg:registers;
begin
	reg.AX:=4;
	intr(nint,reg);
	StopDSoundIN:=reg.AX;
end;

function GetDSoundStatus:integer;
var reg:registers;
begin
	reg.AX:=5;
	intr(nint,reg);
	GetDSoundStatus:=reg.AX;
end;

function GetCardInfo(var CINF:TCardInfo):integer;
var reg:registers;
begin
	reg.AX:=6;
	reg.BX:=ofs(CINF);
	reg.ES:=seg(CINF);
	intr(nint,reg);
	GetCardInfo:=reg.AX;
end;

procedure GetCardGlobalInfo(var CGINF:TCardGlobalInfo);
var reg:registers;
begin
	reg.AX:=7;
	reg.BX:=ofs(CGINF);
	reg.ES:=seg(CGINF);
	intr(nint,reg);
end;

function GetAccurateFreq(ctype:word;cdata:longint;freq:word):word;
var reg:registers;
begin
	reg.AX:=8;
	reg.BX:=ctype;
	reg.CX:=cdata;
	reg.DX:=cdata shr 16;
	reg.SI:=freq;
	intr(nint,reg);
	GetAccurateFreq:=reg.AX;
end;

function StartRPMod(var DSinfo:TDSoundInfo;var Module:TRPMModule):integer;
var reg:registers;
begin
	reg.AX:=20;
	reg.BX:=ofs(DSinfo);
	reg.ES:=seg(DSinfo);
	reg.CX:=ofs(Module);
	reg.DX:=seg(Module);
	intr(nint,reg);
	StartRPMod:=reg.AX;
end;

function StopRPMod:integer;
var reg:registers;
begin
	reg.AX:=21;
	intr(nint,reg);
	StopRPMod:=reg.AX;
end;

procedure SetRPMVoice(voice:integer;vok:integer);
var reg:registers;
begin
	reg.AX:=22;
	reg.BX:=voice;
	reg.CX:=vok;
	intr(nint,reg);
end;

procedure SetRPMVolOut(vout,bal:integer);
var reg:registers;
begin
	reg.AX:=23;
	reg.BX:=vout;
	reg.CX:=bal;
	intr(nint,reg);
end;

procedure SetRPMPattern(pat:integer);
var reg:registers;
begin
	reg.AX:=24;
	reg.BX:=pat;
	intr(nint,reg);
end;

procedure GetRPMStatus(var RPMS:TRPMStatus);
var reg:registers;
begin
	reg.AX:=25;
	reg.BX:=ofs(RPMS);
	reg.ES:=seg(RPMS);
	intr(nint,reg);
end;

function LoadMod(var M:TRPMModule;var name:string):integer;
var reg:registers;
begin
	reg.AX:=30;
	reg.BX:=ofs(M);
	reg.ES:=seg(M);
	reg.CX:=ofs(name);
	reg.DX:=seg(name);
	intr(nint,reg);
	LoadMod:=reg.AX;
end;

procedure FreeMod(var M:TRPMModule);
var reg:registers;
begin
	reg.AX:=31;
	reg.BX:=ofs(M);
	reg.ES:=seg(M);
	intr(nint,reg);
end;


end.